/** GUI minimap **/

$(function() {

        /* radar settings */
        var wratio = 4096 / window.innerWidth;
        var hratio = 2160 / window.innerHeight;
        var mw = $("#minimap").width();
        var mh = $("#minimap").height();
        var mwratio = mw / wratio;
        var mhratio = mh / hratio;
        $("#minimap-radar").width(mwratio);
        $("#minimap-radar").height(mhratio);
        var vpos = mw / 2 - mwratio / 2;
        var hpos = mh / 2 - mhratio / 2;
        $("#minimap-radar").css({
                "left": vpos + "px",
                "top": hpos + "px"
        });

        /**
         * Minimap events
         **/
        var minimapClicked = false;

        var rw = $("#minimap-radar").width();
        var rh = $("#minimap-radar").height();
        $("#minimap").mousedown(function(ev) {
                if (!minimapClicked && $("#minimap-linkback").css("display") == "none") {
                        minimapEvent(ev);
                        minimapClicked = true;
                }
        });
        $("#minimap").mousemove(function(ev) {
                if (minimapClicked) minimapEvent(ev);
        });
        $("#minimap").mouseup(function() {
                minimapClicked = false;
        });
        $("#minimap-radar").mousedown(function(ev) {
                if ($("#minimap-linkback").css("display") == "none") {
                        ev.preventDefault();
                        ev.stopPropagation();
                        minimapClicked = true;
                }
        });
        $("#minimap-radar").mousemove(function(ev) {});
        $("#minimap-radar").mouseup(function() {
                minimapClicked = false;
        });

        function minimapEvent(ev) {
                rw = $("#minimap-radar").width();
                rh = $("#minimap-radar").height();
                moffl = $('#minimap').offset().left;
                mofft = $('#minimap').offset().top;
                ox = ev.pageX - moffl - rw / 2;
                oy = ev.pageY - mofft - rh / 2;

                if (ox < 0 || isNaN(ox)) ox = 0;
                if (oy < 0 || isNaN(oy)) oy = 0;
                if (ox > mw - rw) ox = mw - rw - 5;
                if (oy > mh - rh) oy = mh - rh - 5;

                $("#minimap-radar").css({
                        left: ox + "px",
                        top: oy + "px"
                });
                game.container.x = -1 * (ox / (mw - rw)) * (game.map.image.width - game.canvas.width);
                game.container.y = -1 * (oy / (mh - rh)) * (game.map.image.height - game.canvas.height);
        }
        $("#minimap-linkback").mouseover(function(ev) {
                $("#minimap-linkback").css({
                        "background-color": "rgba(0, 0, 0, 0.3)",
                        "cursor": "pointer"
                });
        });
        $("#minimap-linkback").mouseout(function(ev) {
                $("#minimap-linkback").css({
                        "background-color": "transparent",
                        "cursor": "default"
                });
        });
        $("#minimap-linkback").click(function(ev) {
                if ($("#rightbuttons").not(":visible"))
                        $("#rightbuttons").fadeIn(500, function() {
                                if (($("#minimap").is(":visible") && (window.innerWidth < 1216)) || ($("#minimap").not(":visible") && (window.innerWidth < 945))) // 1162  891
                                        $("#buttons").clearQueue().finish().animate({
                                        height: "110px"
                                }, 500, "easeOutExpo");
                        });

                $("#button-back").show(); //fadeOut(1000);
                window.location.hash = "city";
        });
});
